from django.views import generic

from .models import LogViewer, LoggedApplication


class IndexView(generic.ListView):
    template_name = 'logs_viewer/index.html'
    context_object_name = 'logged_application'

    def get_queryset(self):
        return LoggedApplication.objects.all()


class DetailView(generic.DetailView):
    model = LoggedApplication
    template_name = 'logs_viewer/detail.html'

    def get(self, request, *args, **kwargs):
        self.object = self.get_object()
        context = self.get_context_data(object=self.object)
        logs = self.object.logs.all()
        for log in logs:
            log.set_content()
        context['logs'] = logs
        return self.render_to_response(context)