from django.contrib import admin

from logs_viewer.models import LogViewer, LoggedApplication


class LogViewerInline(admin.TabularInline):
    model = LogViewer
    extra = 2


class LoggedApplicationAdmin(admin.ModelAdmin):
    inlines = [LogViewerInline]

admin.site.register(LoggedApplication, LoggedApplicationAdmin)