#!/bin/bash

API_IMAGE="logs-viewer-img"
API_CONTAINER="logs-viewer"
API_TEST_CONTAINER="logs-viewer-test"

function log_info {
  echo -e "\e[44m$1\e[49m"
}

function log_error {
  echo -e "\e[101m$1\e[49m"
}

function stop_on_error {
    if [[ $1 -ne 0 ]]; then
        log_error "$2"
        exit 1
    fi
}

function stop_container {
    NB_CONTAINER=`docker ps -f name=$1 | wc -l`

    if [[ $NB_CONTAINER -gt 1 ]]; then
      log_info "Stop $1"
      docker stop $1
      stop_on_error $? "Docker stop failed"
    fi
}

function remove_container {
    stop_container $1
    NB_CONTAINER=`docker ps -af name=$1 | wc -l`

    if [[ $NB_CONTAINER -gt 1 ]]; then
      log_info "Remove $1"
      docker rm $1
      stop_on_error $? "Docker rm failed"
    fi
}

log_info "Build images"
docker build -t $API_IMAGE .
stop_on_error $? "Docker build failed"

remove_container "$API_TEST_CONTAINER"
log_info "Run tests"
docker run -d --name $API_TEST_CONTAINER $API_IMAGE
docker exec $API_TEST_CONTAINER coverage run manage.py test --noinput
stop_on_error $? "Tests failed"
docker exec $API_TEST_CONTAINER coverage report --skip-covered
remove_container "$API_TEST_CONTAINER"

remove_container "$API_CONTAINER"

log_info "Run image"
docker run -d -p 8001:80 -v $LOGS_DIR:/tmp/log:z --name $API_CONTAINER $API_IMAGE
stop_on_error $? "Docker run failed"
