# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'some-secret'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False
ALLOWED_HOSTS = [ALLOWED_HOSTS_LIST]

# SECURITY WARNING: don't run cors_with origin_allow_all turned on in production!
CORS_ORIGIN_ALLOW_ALL = True
CORS_ALLOW_CREDENTIALS = True

# Use PyMySQL as engine, since it supports python 3
try:
    import pymysql

    pymysql.install_as_MySQLdb()
except ImportError:
    pass

# Database
# https://docs.djangoproject.com/en/1.8/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'DB_ENGINE',
        'NAME': 'DB_NAME',
        'USER': 'DB_USER',
        'PASSWORD': 'DB_PASSWD',
        'HOST': 'DB_HOST',
        'PORT': 'DB_PORT'
    }
}

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

STATIC_ROOT = 'static/'

STATIC_URL = '/static/'
